﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace PI.ZB.N1200.ELearning.WinForms.School
{
    public partial class FSchoolSearch : PI.FM.N000.Base.WinForms.Controls.FSearchTemplate
    {
        public FSchoolSearch()
        {
            InitializeComponent();

            this._gComboBoxTop.SetDataSourceStringList(new string[] {
                "50",
                "100",
                "250",
                "500",
                "1000"
               });
        }

        public BL.BO.School.Search Search
        {
            get { return (BL.BO.School.Search)_search; }
            set 
            { 
                _search = value;
                LoadSearch();
            }
        }

        private void LoadSearch()
        {
            if (Search == null) 
            {
                Search = new BL.BO.School.Search();
            }


            base.LoadTop(Search.Top, _gComboBoxTop, _gCheckBoxTop);
            base.LoadString(Search.Address, _gTextBoxAddress, _gCheckBoxAddress);
            base.LoadString(Search.Town, _gTextBoxTown, _gCheckBoxTown);
            base.LoadString(Search.Name, _gTextBoxName, _gCheckBoxName);
        }

        private void SaveSearch()
        {
            Search.Top = base.SaveTop(_gComboBoxTop, _gCheckBoxTop);
            Search.Address = base.SaveString(_gTextBoxAddress, _gCheckBoxAddress);
            Search.Name = base.SaveString(_gTextBoxName, _gCheckBoxName);
            Search.Town = base.SaveString(_gTextBoxTown, _gCheckBoxTown);
        }


        private void ButtonCancell_Click(object sender, EventArgs e)
        {
            DialogResult = System.Windows.Forms.DialogResult.Cancel;
            Close();
        }

        private void ButtonOK_Click(object sender, EventArgs e)
        {
            DialogResult = System.Windows.Forms.DialogResult.OK;
            SaveSearch();
            Close();
        }
    }
}
